%define module_name File-ShareDir-Dist
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Copy.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Locate per-dist shared files
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/File::ShareDir::Dist

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the File::ShareDir::Dist manpage finds share directories for distributions.  It is similar to the File::ShareDir manpage
with a few differences:

=over 4

=item Only supports distribution directories.

It doesn't support perl modules or perl class directories.  I have never really needed anything
other than a per-dist share directory.

=item Doesn't compute filenames.

Doesn't compute files in the share directory for you.  This is what the File::Spec manpage or the Path::Tiny manpage
are for.

=item Doesn't support old style shares.

For some reason there are two types.  I have never seen or needed the older type.

=item Hopefully doesn't find the wrong directory.

It doesn't blindly go finding the first share directory in @INC that matches the dist name.  It actually
checks to see that it matches the .pm file that goes along with it.

That does mean that you need to have a .pm that corresponds to your dist name.  This is not
always the case for some older historical distributions, but it has been the recommended convetion
for quite some time.

=item No non-core dependencies.

the File::ShareDir manpage only has the Class::Inspector manpage, but since we are only doing per-dist share
directories we don't even need that.

The goal of this project is to have no non-core dependencies for the two most recent production
versions of Perl.  As of this writing that means Perl 5.26 and 5.24.  In the future, we `may' add
dependencies on modules that are not part of the Perl core on older Perls.

=item Works in your development tree.

Uses the huristic, for determining if you are in a development tree, and if so, uses the common
convention to find the directory named `share'.  If you are using a relative path in `@INC',
if the directory `share' is a sibling of that relative entry in `@INC' and if the last element
in that relative path is `lib'.

Example, if you have the directory structure:

 lib/Foo/Bar/Baz.pm
 share/data

and you invoke perl with

 %% perl -Ilib -MFoo::Bar::Baz -MFile::ShareDir::Dist=dist_share -E ...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc author.yml Changes README LICENSE
%perl_vendor_privlib/F*
%perl_vendor_privlib/A*

%changelog
