%define module_name FileDirUtil
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(Params/Coerce.pm) perl(Path/Class/Dir.pm) perl(Path/Class/File.pm) perl(Test/More.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: A Moose Role for basic File IO
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MT/MTW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
FileDirUtil is a convenience Moose Role for basic File IO, providing
transparent access to the Path::Class::File manpage and the Path::Class::Dir manpage for
input files and output directories, respectively, via the following
attributes:

=over 3

=item ifile

A string representing the path to an input file in platform-native
syntax, e.g. *'moo/foo.bar'*. This will be coerced into a
the Path::Class::File manpage object.

=item odir

A the Path::Class::Dir manpage object or an ArrayRef specifying path segments
of directories which will be joined to create a single
the Path::Class::Dir manpage directory object.

=back
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/F*

%changelog
