# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.85
%define module_name Filesys-DfPortable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.85
Release: alt7
Summary: Perl extension for filesystem disk space information..
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/I/IG/IGUTHRIE/%module_name-%module_version.tar.gz

%description
This module provides a portable way to obtain filesystem disk space.
information. 

The module should work with all versions of Windows (95 and up),
and with all flavors of Unix that implement the `statvfs' or the `statfs'
calls. This would include Linux, *BSD, HP-UX, AIX, Solaris, Mac OS X, Irix,
Cygwin, etc ...

This module differs from Filesys::Df in that it has added support
for Windows, but does not support open filehandles as a argument.

`dfportable()' requires a directory argument that represents the filesystem
you want to query. There is also an optional block size argument so that
you can tailor the size of the values returned. The default block size
is 1, this will cause the function to return the values in bytes.
If you never use the block size argument, then you can think of any
instance of "blocks" in this document to really mean "bytes". 

`dfportable()' returns a reference to a hash. The keys available in 
the hash are as follows:

{blocks} = Total blocks on the filesystem.

{bfree} = Total blocks free on the filesystem.

{bavail} = Total blocks available to the user executing the Perl 
application. This can be different than `{bfree}' if you have per-user 
quotas on the filesystem, or if the super user has a reserved amount.
`{bavail}' can also be a negative value because of this. For instance
if there is more space being used then you have available to you.

{bused} = Total blocks used on the filesystem.

{per} = Percent of disk space used. This is based on the disk space
available to the user executing the application. In other words, if
the filesystem has 10%% of its space reserved for the superuser, then
the percent used can go up to 110%%.

You can obtain inode information through the module as well. But you
must call `exists()' on the `{files}' key to make sure the information is
available. Some filesystems may not return inode information, for
example Windows, and some NFS filesystems.

Here are the available inode keys:

{files} = Total inodes on the filesystem.

{ffree} = Total inodes free on the filesystem.

{favail} = Total inodes available to the user executing the application.
See the rules for the `{bavail}' key.

{fused} = Total inodes used on the filesystem.

{fper} = Percent of inodes used on the filesystem. See rules for the `{per}'
key.

If the `dfportable()' call fails for any reason, it will return
`undef'. This will probably happen if you do anything crazy like try
to get information for /proc, or if you pass an invalid filesystem name,
or if there is an internal error. `dfportable()' will `croak()' if you pass
it a undefined value.

Requirements:
Your system must contain `statvfs()', `statfs()', `GetDiskFreeSpaceA()', or `GetDiskFreeSpaceEx()'.
You must be running Perl 5.6 or higher.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/F*
%perl_vendor_autolib/*

%changelog
