# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Handle.pm) perl(IO/Select.pm) perl(IPC/Open3.pm)
# END SourceDeps(oneline)
%define module_version 0.20
%define module_name Filesys-Ext2
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.20
Release: alt5
Summary: Interface to ext2 and ext3 filesystem attributes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JP/JPIERCE/%module_name-%module_version.tgz
BuildArch: noarch

%description
You may specify the path of the e2fsprogs upon use

  use Filesys::Ext2 {PATH=>'/path/to/binaries'};

Otherwise the module will use the default path /usr/bin/

=over 8

=item chattr(*$mask*, @files)

Change the mode of @files to match *$mask*.
*$mask* may be a bitmask or symbolic mode eg;

  =DIE
  +cad
  -s-i

Throws an exception upon failure.

=item lsattr(@files)

Returns bitmasks respresenting the attributes of @files.

Throws an exception upon failure.

=item lstat($file)

Same as `CORE::lstat', but appends the numerical attribute bitmask.

=item stat($file)

Same as `CORE::stat',  but appends the numerical attribute bitmask.

=item calcSymMask(*$mask*)

Accepts a bitmask and returns the symbolic mode.
In list context it returns a symbol list like lsattr,
in scalar context it returns a string that matches the
*-* region of lsattr(1) eg;

  s-----A------

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE.pod CHANGES TODO README
%perl_vendor_privlib/F*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
