# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(FileHandle.pm) perl(Filter/Simple/Compile.pm) perl(FindBin.pm) perl(IO/All.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Signature.pm) perl(Net/FTP.pm) perl(Quantum/Superpositions.pm) perl(Socket.pm) perl(Switch.pm) perl(Test.pm) perl(YAML.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Filter-Macro
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Make macro modules that are expanded inline
Group: Development/Perl
License: MIT
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AU/AUTRIJUS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
If many of your programs begin with the same lines, it may make sense to
abstract them away into a module, and `use' that module instead.

Sadly, it does not work that way, because by default, all lexical pragmas,
source filters and subroutine imports invoked in MyHandyModules.pm takes
effect in that module, *not* the calling programs.

One way to solve this problem is to use Filter::Include:

    use Filter::Include;
    include MyHandyModules;

However, it would be really nice if MyHandyModules.pm could define the
macro-like semantic itself, instead of placing the burden on the caller.

This module lets you do precisely that.  All you need to do is to put one
line in MyHandyModules.pm, after the `package MyHandyModules;' line:

    use Filter::Macro;

With this, a program or module that says `use Filter::Macro' will expand
lines below `use Filter::Macro' into their own code, instead of the default
semantic of evaluating them in the `MyHandyModules' package.

Line numbers in error and warning messages are unaffected by this module;
they still point to the correct file name and line numbers.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/F*

%changelog
