# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Filter/Simple.pm) perl(Test/More.pm) perl(Test/Simple.pm) perl(if.pm)
# END SourceDeps(oneline)
%define module_version 1.1
%define module_name Filter-Unpound
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: Selective uncommenting for debugging.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CL/CLSN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
An even more simplified source filter, based on the Filter::Simple manpage and
somewhat like the Filter::Uncomment manpage, but with a different syntax that
might be easier to work with.

Anything commented out by a comment in the form `#word#' can be
uncommented by including this package with suitable arguments.
Essentially, if you execute

    perl -MFilter::Unpound=word script.pl

then the string "#word#" is removed wherever it may appear in the
code--which may then expose some previously commented-out
instructions.  This may make a huge difference in performance (in a
tight loop) versus calling a debug function that checks if a debug
variable is set.  You can have several different "uncomment" tags and
use them selectively.  A line tagged with more than one, as above, is
activated if *any* one is activated (any *block* of keywords
containing `#word#' is removed, not just the single one).  You can
make it have to have *all* the tags this way:

   #foo#bar# print "This line prints with either foo or bar.\n";
   #foo# #bar# print "This line prints only with both.\n";

You would have to say `perl -MFilter::Unpound=foo,bar' to get the second
line to print, whereas either `perl -MFilter::Unpound=foo' or `perl
-MFilter::Unpound=bar' will suffice for the first.

Note that the `#word#' must be followed by whitespace, before the
code that is being uncommented.

You can also uncomment multi-line pieces of code which are ordinarily
commented out by wrapping them in a special "string comment" using Perl
here-strings.

    ;<<'foo'
    print "This code is normally ignored, just shoved into a string.\n";
    foo
    ;

    ;my $bar=<<'BAR'
    print "Also ignored code.\n";
    print "The dummy variable is for avoiding warnings\n";
    BAR
    ;

    ;$bar=<<'BAR'
    print "Same as above... ";
    print "(except didn't declare \$bar again.)\n";
    BAR
    ;

The string comment header must appear just as shown: on its own line,
with the keyword surrounded by single quotes, and the << must be
preceded by a semicolon (just in case you have some code that uses a
here-string that starts on its own line; the semicolon makes the
string unusable for anything, so it can't be purposeful in your code.
You shouldn't be using your Unpound keywords as ordinary delimiters
anyway, though.)  Note that this will cause "void" warnings (during
ordinary, not Unpounded, execution) if you have those enabled.  You
can optionally assign to a variable if you want to avoid the warnings
(in which case, of course, make sure that you don't use a variable
with that name anywhere that could cause interference).  You can also
optionally declare the variable with "`my'" on the line as shown
above.  When "foo" is selected, Unpound will delete lines that look
like "`;<<'foo''" (optionally assigned to a variable) and lines
that have only "`foo'" on them, so this code will be uncommented (so
don't use the keywords as delimiters for anything important in the
code, of course.)


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md
%perl_vendor_privlib/F*

%changelog
