%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/SSLeay.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.4
%define module_name Finance-BankVal-International-GetABA
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4
Release: alt1
Summary: >new();
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/U/UN/UNIFIEDSW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module handles all of the restful web service calls to Unified Software's
BankValInternational ABA service. It also handles fail over to the back up services
transparently to the calling script. It can be called in a procedural or OO fashion
(see synopsis)

The exportable method &getABA(); takes a number of parameters including;

1: Format 	- the response format (either xml, json or csv)

2: ABA		- the ABA code to be validated

3: UserID	- available from www.unifiedsoftware.co.uk

4: PIN		- available from www.unifiedsoftware.co.uk

(UserID and PIN are available from http://www.unifiedsoftware.co.uk/freetrial/free-trial-home.html)

The order of the parameters must be as above. The UserID and PIN can be stored in the InternationalLoginConfig.txt
file bundled with this module, the use of this file saves passing the PIN and user ID data with each call to getABA.
For example, a call to validate an ABA routing code passing the user ID and PIN as parameters
and printing the reply to console should follow this form:

=====================================================================

 #!/usr/bin/perl

 use Finance::BankVal::International::GetABA qw(&getABA);

 my $ans = getABA('XML','ABAcode','xmpl123','12345');

 print $ans;

=============================OR for OO===============================

 use Finance::BankVal::International::GetABA;

 $abaObj = Finance::BankVal::International::GetABA->new();
 my $ans = $abaObj->getABA('format','ABA','xmpl123','12345');

 print $ans;

=====================================================================

valid parameter lists are:-

getABA('$format','$aba','$userID','$PIN');

getABA('$format','$aba');

n.b. the last parameter list requires that the user ID and PIN are stored
in the *InternationalLoginConfig.txt* file bundled with this module.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes~ README Changes
%perl_vendor_privlib/F*

%changelog
