# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(Test/More.pm) perl(Time/Moment.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Finance-StockAccount
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Analyze past transactions in a personal stock account.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JR/JREFIOR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Analyze past transactions in a personal stock account.  Find out your total
profit, annual profit, quarterly profit, monthly profit, or profit for any
other arbitrary date/time range.  Discover what the most cash you had invested
in stocks at once was, over the course of your account from when it opened to
the present, or for any period.  Or get the total cash you spent on all stock
purchases, call that your totalOutlays and learn how the ratio of profit to
that totalOutlays changed from period to period.  Find out how much you spent
on commissions.  Match up the results with your experience by looking at profit
for each stock symbol separately.

    use Finance::StockAccount;

    # Object-oriented, so instantiate your object
    my $sa = Finance::StockAccount->new();

    # Now add your trades
    # One (fake/fantasy) trade a day for a week in January...
    $sa->stockTransaction({ # total outlay: 1000
        symbol          => 'AAA',
        dateString      => '20140106T150500Z', # This is a Time::Moment string, more on that below
        action          => 'buy',              # in the 'Required: date' section
        quantity        => 198,
        price           => 5,
        commission      => 10,
    });
    $sa->stockTransaction({ # total outlay: 1000
        symbol          => 'BBB',
        dateString      => '20140107T150500Z',
        action          => 'buy',
        quantity        => 99,
        price           => 10,
        commission      => 10,
    });
    $sa->stockTransaction({ # total revenue: 600
        symbol          => 'AAA',
        dateString      => '20140108T150500Z',
        action          => 'sell',
        quantity        => 100,
        price           => 6.10,
        commission      => 10,
    });
    $sa->stockTransaction({ # total revenue: 1070
        symbol          => 'BBB',
        dateString      => '20140109T150500Z',
        action          => 'sell',
        quantity        => 99,
        price           => 11,
        commission      => 19,
    });
    $sa->stockTransaction({ # total revenue: 670
        symbol          => 'AAA',
        dateString      => '20140110T150500Z',
        action          => 'sell',
        quantity        => 98,
        price           => 7,
        commission      => 16,
    });

    # How much did you make (or lose)?
    $sa->profit();                    # 340

    # What was the most cash you had invested in stocks at once?
    $sa->maxCashInvested();           # 2000

    # How much profit did you make as a share of the max you invested?
    $sa->profitOverMaxCashInvested(); # 0.17

    # Prefer just profit over outlays?  No problem.  It happens to be the same in this case.
    $sa->profitOverOutlays();         # 0.17

    # If you kept up that rate of profit over a year how much would you make?
    $sa->profitOverYears();           # 31046.25 (Wish I were that lucky.)

    # How much did you pay your broker?
    $sa->commissions();               # 65

    # How many transactions were counted in these statistics?
    $sa->numberOfTrades();            # 5

    # Get a list of statistics you can loop through
    my $stats = $sa->stats();

    # or get it broken down by date period
    $sa->annualStats();
    $sa->quarterlyStats();
    $sa->monthlyStats();

    # Want me to iterate through it and make it a string for you?
    print $sa->statsString();

    # Want that by date too?
    print $sa->annualStatsString();
    print $sa->quarterlyStatsString();
    print $sa->monthlyStatsString();

    # Get a simple one-stock-per-line breakdown of how you did
    print $sa->summaryByStock();

    # Need to exclude a couple stocks from analysis?
    $sa->skipStocks(qw(AAA BBB));

    # Include AAA and BBB again
    $sa->resetSkipStocks();

    # Curious how the module is doing its accounting?
    # Print the realizations (matches of acquisitions to divestment):
    print $sa->realizationsString();


My online brokerage account does not allow me to easily see how my stock
account is performing.  With a little research, I found this was common
practice with both online and offline brokerages, as well as financial
advisers.  So I wrote this software to find out my actual account performance,
and shared these modules so others could find out theirs.

This is a pure stock-transaction based set of modules.  Currently understood
transaction types include buy, sell, short, and cover.  This version (version
0.01) does not consider cash or dividends, but I would like to add those
features in future releases.  Because of that limitation, calculations cannot
be based purely on cash -- but rather on appreciation and depreciation of
stocks, and timing of transactions -- which gives an interesting (and I think
useful) perspective on account performance.

Looking at the "Analyze" tools in my OptionsXpress online brokerage account, I
saw it always used a "Last In, First Out" accounting method, which, frankly, is
ridiculous in terms of evaluating my stock trading performance.

So in these modules, accounting is done by what I call the Greatest Realized
Benefit (GRB) method: divestments (sales and covers) are processed from oldest
to newest, and one or more prior acquisitions (buys and shorts) are matched
with the sale by availability (meaning not all acquisition shares are already
tied to another divestment) and lowest cost of the acquisition.  Future
releases may add alternative accounting methods that could be selected by the
user, and I welcome your suggestions for those.

Along the way I tried to create a pure stock transaction class and a pure stock
class.  If you need such a thing, please look at

    Finance::StockAccount::Transaction
    Finance::StockAccount::Stock

which are included in the Finance::StockAccount installation.

If you happen to have an OptionsXpress online brokerage account you can import
the whole thing in one go with Finance::StockAccount::Import::OptionsXpress.  I
would like to add more formats, so, if you can, please donate an export from a
brokerage account to help this along.

Dates are stored as Time::Moment objects, and may be specified either as a
Time::Moment object (using the 'tm' property) or one of the string formats
natively understood by Time::Moment (using the 'dateString' property).
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/F*
%perl_vendor_privlib/auto/*

%changelog
