%define module_version 0.04
%define module_name Firewall-PaloAlto
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(LWP/UserAgent.pm) perl(List/Flatten.pm) perl(Modern/Perl.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Params/Validate.pm) perl(Test/Exception.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Interact with a Palo Alto firewall's API through Perl.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PU/PUGLET/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The Firewall::PaloAlto module provides interfaces into the XML API of a Palo Alto firewall.

    use Firewall::PaloAlto;

    my $fw = Firewall::PaloAlto->new(host => 'pa.local', username => 'admin', password => 'admin');
    $fw->connect();

    #Add a new virtual system
    $fw->address('set', vsys_id => 6, 'display-name' => "Script_Tenant");

    #Add a virtual router to the chassis
    $fw->virtual_router('set', vr_name => 'NEW_VR', interface => [ 'ae1.65', 'ae1.66' ]);

    #Add a new address - if the vsys is not specified it defaults to vsys1.
    #This works for devices such as the VM series, which only have a vsys1. 
    $fw->address('set', name => 'Google_DNS', ip-netmask => '8.8.8.8/32');

    #Get the configuration for the newly created address:
    my $address_config = $fw->address('get', name => 'Google_DNS');

    #Delete the newly created address
    $fw->address('delete', name => 'Google_DNS);

A list of functions that can be exported.  You can delete this section
if you don't export anything, such as for a purely object-oriented module.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/F*

%changelog
