# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(CGI/Carp.pm) perl(Data/Omap.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Math/Int2Base.pm) perl(SDBM_File.pm) perl(Test/More.pm) perl(URI.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name FlatFile-DataStore
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Perl module that implements a flatfile
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BB/BBAXTER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
FlatFile::DataStore implements a simple flatfile datastore.  When you
create (store) a new record, it is appended to the flatfile.  When you
update an existing record, the existing entry in the flatfile is
flagged as updated, and the updated record is appended to the
flatfile.  When you delete a record, the existing entry is flagged as
deleted, and a "delete record" is *appended* to the flatfile.

The result is that all versions of a record are retained in the
datastore, and running a history will return all of them.  Another
result is that each record in the datastore represents a transaction:
create, update, or delete.

Methods support the following actions:

 - create
 - retrieve
 - update
 - delete
 - history

Additionally, FlatFile::DataStore::Utils provides the
methods

 - validate
 - migrate

and others.

See FlatFile::DataStore::Tiehash for a tied interface.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/F*

%changelog
