Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Compress/Zlib.pm) perl(Pod/Usage.pm) perl(Term/ReadKey.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Flickr-API
Version:        1.28
Release:        alt2_23
Summary:        Perl interface to the Flickr API
License:        Artistic 2.0
URL:            https://metacpan.org/release/Flickr-API
Source0:        https://cpan.metacpan.org/authors/id/L/LB/LBMOORE/Flickr-API-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
# Compress::Zlib is optional
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(Encode.pm)
# HTTP::Message 1.56 needed because it brings decoded_content()
BuildRequires:  perl(HTTP/Message.pm)
BuildRequires:  perl(HTTP/Request.pm)
BuildRequires:  perl(HTTP/Request/Common.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(Net/OAuth.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XML/LibXML/Simple.pm)
BuildRequires:  perl(XML/Parser/Lite/Tree.pm)
# Tests:
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Term/ReadLine.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Script.pm)
# HTTP::Message 1.56 needed because it brings decoded_content()
Requires:       perl(HTTP/Message.pm) >= 1.560
Requires:       perl(URI.pm) >= 1.180
Requires:       perl(XML/Parser/Lite/Tree.pm) >= 0.060

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(URI\|XML.Parser.Lite.Tree\).pm)/d

%description
A simple interface for using the Flickr API.

%prep
%setup -q -n Flickr-API-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor </dev/null
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes examples README
%{_bindir}/*
%{perl_vendor_privlib}/*
%{_mandir}/man1/*

%changelog
