%define module_name Font-FreeType
# BEGIN SourceDeps(oneline):
BuildRequires: libfreetype-devel perl(Devel/CheckLib.pm) perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(File/Which.pm) perl(IO/File.pm) perl(Image/Magick.pm) perl(Pod/Checker.pm) perl(Test/Warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt4
Summary: read font files and render glyphs from Perl using FreeType2
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DM/DMOL/%{module_name}-%{version}.tar.gz

%description
This module allows Perl programs to conveniently read information from
font files.  All the font access is done through the FreeType2 library,
which supports many formats.  It can render images of characters with
high-quality hinting and antialiasing, extract metrics information, and
extract the outlines of characters in scalable formats like TrueType.

Warning: this module is currently in 'beta' stage.  It'll be another
release or two before it stabilizes.  The API may change in ways that
break programs based on it, but I don't think it will change much.
Some of the values returned may be wrong, or not scaled correctly.
See the *TODO* file to get a handle on how far along this work is.
Contributions welcome, particularly if you know more than I do (which
isn't much) about fonts and the FreeType2 library.

The Font::FreeType API is not intended to replicate the C API of the
FreeType library -- it offers a much more Perl-friendly interface.

The quickest way to get started with this library is to look at the
examples in the *examples* directory of the distribution.  Full
details of the API are contained in this documentation, and (more
importantly) the documentation for the
Font::FreeType::Face and
Font::FreeType::Glyph classes.

To use the library, first create a Font::FreeType object.  This can
be used to load faces from files, for example:

    my $freetype = Font::FreeType->new;
    my $face = $freetype->face('Vera.ttf');

If your font is scalable (i.e., not a bitmapped font) then set the size
and resolution you want to see it at, for example 24pt at 100dpi:

    $face->set_char_size(24, 24, 100, 100);

Then load a particular glyph (an image of a character), either by
character code (in Unicode) or the actual character:

    my $glyph = $face->glyph_from_char_code(65);
    my $glyph = $face->glyph_from_char('A');

Glyphs can be rendered to bitmap images, among other things:

    my $bitmap = $glyph->bitmap;

See the documentation for Font::FreeType::Glyph
for details of the format of the bitmap array reference that returns, and
for other ways to get information about a glyph.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes TODO examples
%perl_vendor_archlib/F*
%perl_vendor_autolib/*

%changelog
