%define module_name Footprintless
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd.pm) perl(Archive/Extract.pm) perl(Archive/Extract/Libarchive.pm) perl(Archive/Tar.pm) perl(Config/Entities.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Getopt/Long/Descriptive.pm) perl(IO/Uncompress/Unzip.pm) perl(IPC/Run.pm) perl(IPC/Run3.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/Any.pm) perl(Maven/Agent.pm) perl(Net/Domain.pm) perl(Pod/Usage.pm) perl(Template/Resolver.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(URI.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.29
Release: alt1
Summary: A utility for managing systems with minimal installs
Group: Development/Perl
License: perl
URL: https://github.com/lucastheisen/footprintless

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LT/LTHEISEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Footprintless is an automation framework with an application frontend for
managing diverse software stacks in a consistent fashion.  It provides a
minimally invasive approach to configuration management.  At its core, 
the Config::Entities manpage are used to define the whole
system.  Once defined, the
entities are used by all of the Footprintless modules to decouple the 
environment from the action.  The environment is defined by the 
entities used to create 
command options.  Specifically:

    hostname
    ssh
    sudo_username
    username

Each module will have its own entities structure, see them for more 
details.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE docs
%perl_vendor_privlib/F*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
