# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(IO/Scalar.pm) perl(IO/Tokenized.pm) perl(IO/Tokenized/File.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(Tree/DAG_Node.pm) perl(YAML.pm) perl(base.pm) perl(charnames.pm) perl(inc/Module/Install.pm) perl(warnings/register.pm)
# END SourceDeps(oneline)
%define module_version 0.075
%define module_name FrameMaker-MifTree
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.075
Release: alt1
Summary: A MIF Parser
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RS/RST/%module_name/FrameMaker-MifTree-%module_version.tar.gz
BuildArch: noarch

%description
The FrameMaker::MifTree class is implemented as a Tree::DAG_Node subclass, and
thus inherits all the methods of that class. Two methods are overridden. Please
read the Tree::DAG_Node manpage to see what other methods are available.

MIF (Maker Interchange Format) is an Adobe FrameMaker file format in ASCII,
consisting of statements that create an easily parsed, readable text file of
all the text, graphics, formatting, and layout constructs that FrameMaker
understands. Because MIF is an alternative representation of a FrameMaker
document, it allows FrameMaker and other applications to exchange information
while preserving graphics, document content, and format.

This document does not tell you what the syntax of a MIF file is, nor does it
document the meaning of the MIF statements. For this, please read (and re-read)
the MIF_Reference.pdf, provided by Adobe.

MifTree not only knows the MIF syntax, but it also has some understanding of
the allowed structures (within their contexts) and attribute types. The file
FrameMaker/MifTree/MifTreeTags holds all the valid MIF statements and the
attribute type for every statement. This file may need some improvement, as it
is created by analyzing a large collection of MIF files written by FrameMaker
(and an automatic analysis of the *MIF Reference*, which showed several typos
and inconsistencies in that manual). The current file is for MIF version 7.00.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/F*
%perl_vendor_privlib/I*

%changelog
