# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_name Function-Runner
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Define functions at a higher level and run them
Group: Development/Perl
License: perl
URL: https://github.com/hoekit/Function-Runner

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HO/HOEKIT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Function::Runner provides a way to define the steps of a function and
the logical flow between the steps using just hashrefs. The user then
implements the steps that need to be called. The function runner will
then run the function.

This module is handy for functions that are naturally composed of many
hierarchical steps and flows differently depending on the results of
those steps. The function definition helps to clarify the steps and flow
at a higher level.

A function definition (funcdef) is composed of three (3) constructs:
*steps*, *functions* and *results*. Each construct is a string with a
different character prefix to indicate the kind of construct:

    /a_step         # Steps are prefixed with /, like directories

    &a_function     # Functions prefixed with &, like Perl

    :some_result    # Results prefixed with :

The keys of the funcdef hashref is always a *step*. The value of the
funcdef hashref is the step definition (stepdef) defines how that step
is to be executed.

A *stepdef* can be just a *function* if no further steps follow. For
example:

    { '/hello' => '&greet' }

A *stepdef* can also be a hashref that defines the *function* to run
and the *next step* to take depending on the *results* of that
function run.  For example:

    '/checkSwitch' => {
        'run'  => '&checkSwitch',           # Check the switch
        ':on'  => '&bye',                   #   If it's on, leave
        ':off' => '/turnOn',                #   If it's off, turn it on
    },

The next step can either be a function:

    ':on'  => '&bye'            # On "on" result, call the &bye function

or it can be another step:

    ':off' => '/turnOn'         # On "off" result, run the /turnOn step

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/F*

%changelog
