%define module_name Future-Selector
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Future.pm) perl(Future/AsyncAwait.pm) perl(Module/Build.pm) perl(Object/Pad.pm) perl(Scalar/Util.pm) perl(Sublike/Extended.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: manage a collection of pending futures
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PEVANS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Objects in this class maintain a collection of pending the Future manpage instances,
and manage the lifecycle of waiting for their eventual completion. This
provides a central structure for writing asynchronous event-driven programs
using the Future manpage and the Future::IO manpage-based logic.

When writing an asynchronous `Future'-based client, often the program can be
structured similar to a straight-line synchronous program, where at any point
the client is just waiting on sending or receiving one particular message or
data-flow. It therefore suffices to use a simple call/response structure,
perhaps written using the `async' and `await' keywords provided by
the Future::AsyncAwait manpage.

In contrast, a server program often has many things happening at once. It will
be handling multiple clients simultaneously, as well as waiting for new client
connections and any other internal logic it requires to provide data to those
clients. There is not just one obvious pending future at any one time; there
could be several that all need to be monitored for success or failure.

A `Future::Selector' instance helps this situation, by storing an entire set
of pending futures that represent individual sub-divisions of the work of the
program (or a part of it). As each completes, the selector instance informs
the containing code so it can continue to perform the work required to handle
that part, perhaps resulting in more future instances for the selector to
manage.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/F*

%changelog
