# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		perl-GO-TermFinder
Version:	0.86
Release:	alt9_10
Summary:	Identify GO nodes that annotate a group of genes with a significant p-value
License:	MIT
Group:		Development/Other
URL:		https://metacpan.org/release/Go-TermFinder
Source0:	https://cpan.metacpan.org/authors/id/S/SH/SHERLOCK/GO-TermFinder-%{version}.tar.gz

BuildRequires:	coreutils
BuildRequires:	findutils
BuildRequires:  gcc-c++
BuildRequires:	perl-devel
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl(base.pm)
BuildRequires:	perl(CGI.pm)
BuildRequires:	perl(diagnostics.pm)
BuildRequires:	perl(DynaLoader.pm)
BuildRequires:	perl(Exporter.pm)
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(File/Find.pm)
BuildRequires:	perl(GD.pm)
BuildRequires:	perl(GraphViz.pm)
BuildRequires:	perl(IO/File.pm)
BuildRequires:	perl(Storable.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Test.pm)
BuildRequires:	perl(Test/More.pm)
BuildRequires:	perl(vars.pm)
BuildRequires:	perl(warnings.pm)
Source44: import.info


%description
This package is intended to provide a method whereby the P-values of a set
of GO annotations can be determined for a set of genes, based on the number
of genes that exist in the particular genome (or in a selected background
distribution from the genome), and their annotation, and the frequency with
which the GO nodes are annotated across the provided set of genes. The
P-value is simply calculated using the hypergeometric distribution as the
probability of x or more out of n genes having a given annotation, given
that G of N have that annotation in the genome in general. We chose the
hypergeometric distribution (sampling without replacement) since it is more
accurate, though slower to calculate, than the binomial distribution
(sampling with replacement).

%prep
%setup -q -n GO-TermFinder-%{version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS"
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT

find $RPM_BUILD_ROOT -type f -name "*.bs" -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
find $RPM_BUILD_ROOT -type f -name "*.pm" -exec chmod 644 {} \;

# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/*

%changelog
