# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XML/LibXML.pm) perl(XML/Simple.pm) perl(XML/XPath.pm)
# END SourceDeps(oneline)
%define module_name GRNOC-Config
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.9
Release: alt1
Summary: The GRNOC Default Config parser
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BM/BMERUGUR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A module to allow everyone to access config files in a fairly standard way.
Uses XML::XPath and XML::Simple to parse our XML files, and stores all configs it has access to in this module

Setting debug to true will give you extra debugging output (default is off)
Setting force_array to true will return everything in an array even if there is only 1 object returned (default is on)

When asking for attributes denoted by '@' it will return only the attribute(s) without the hash

    use GRNOC::Config;

    my $foo = GRNOC::Config->new(config_file => '/etc/grnoc/db.xml', debug => 0, force_array => 0 schema => '/path/to/schema.csd')
    my $db_username = $foo->get("/config/db/credentials");
    print $db_username->{'user'};
    print $db_username->{'password'};

    #just 1 attribute
    my $user = $foo->get("/config/db/credentials[1]/@user");
    my $password = $foo->get("/config/db/credentials[1]/@password");

    #if I have more than 1 result I get an array
    my $hosts = $foo->get("/config/hosts") or die Dumper($foo->get_error());   
    foreach my $host ($hosts){
_print $host->{'hostname'};
    }

    ##turn debugging on
    $foo->{'debug'} = 1;
    
    ##get errors
    print Dumper($foo->get_errors());

    # I always want an array... even if I only get 1 result
    $foo->{'force_array'} = 1;
    $db_username = $foo->get("/config/db/credentials") or die Dumper($foo->get_error());
    print @{db_username}[0]->{'user'}
    print @{db_username}[0]->{'password'}

   $user = $foo->get("/config/db/credentials[1]/@user") or die Dumper($foo->get_error());
   $password = $foo->get("/config/db/credentials[1]/@password") or die Dumper($foo->get_error());
   $user = @{$user}[0];
   $password = @{$password}[0];
 
   my $valid = $foo->validate();

   if(!$valid){
     print STDERR Dumper($foo->get_error());
   }

   my $valid2 = $foo->validate("/path/to/new/schema.xsd");

    ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/G*

%changelog
