# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Game-Life
%define upstream_version 0.06

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_10

Summary:    Plays Conway's Game of Life
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Game/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Clone.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
Conway's Game of Life is a basic example of finding 'living' patterns in
rather basic rulesets (see *NOTES*). The Game of Life takes place on a 2-D
rectangular grid, with each grid point being either alive or dead. If a
living grid point has 2 or 3 neighbors within the surrounding 8 points, the
point will remain alive in the next generation; any fewer or more will kill
it. A dead grid point will become alive if there are exactly 3 living
neighbors to it. With these simple rules, fascinating structures such as
gliders that move across the grid, glider guns that generate these gliders,
XOR gates, and others have been found.

This module simply provides a way to simulate the Game of Life in Perl.

In terms of coordinate systems as used in 'place_points', 'toggle_point'
and other functions, the first coordinate is the vertical direction, 0 being
the top of the board, and the second is the horizontal direction, 0 being
the left side of the board. Thus, toggling the point of (3,2) will switch
the state of the point in the 4th row and 3rd column.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.json META.yml  README
%perl_vendor_privlib/*


%changelog
