# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Mooish/AttributeBuilder.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define module_name Game-TileMap
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: Representation of tile-based two-dimensional rectangular maps
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRTASTIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Game::TileMap is a module which helps you build and store simple
two-dimensional maps of tiles, where each tile contains only one element. Maps
created from this module are generally considered immutable and should only be
used to define a map, not to store its changing state.

Maps can be created out of strings or arrays of arrays and are stored as an
array of array of the Game::TileMap::Tile manpage. Some helpful features are in place:

=over

=item * map markers (usually just single characters) are translated into objects specified in the legend

Map characters can't be whitespace (whitespace is removed before processing -
can be used for improved visibility).

Legend objects can't be falsy, but other than that they can be anything
(string, object, reference).

=item * each legend object is assigned to a class, which you can query for later

If you add a class `surroundings':

_$legend->add_object('surroundings', '@' => 'trash bin')
_       ->add_object('surroundings', '=' => 'desk')
_       ->add_object('surroundings', 'H' => 'locker')
_       ->add_object('surroundings', 'L' => 'chair');

Then you can easily get information about locations of those tiles on a map:

_my @all_surroundings = $map->get_all_of_class('surroundings');

This array will contains blessed objects of the Game::TileMap::Tile manpage class.

=item * you define how your maps look yourself

Only predefined objects are `walls' (can't be accessed and are considered not
a part of map) and `voids' (can't be accessed, but are a part of map). Their
predefined class is `terrain'. You are free to introduce as many objects and
classes as needed.

=item * bottom-left corner of the stringified map is at [0;0], while top-right is at [max;max]

This lets you think of a map like you think of a coordinate frame (first quarter).

=item * map array has X coordinates in first dimension and Y coordinates in second dimension

This way you can get more familiar notation:

_$map->coordinates->[3][5]; # actual point at [3;5]

=item * supports multi-charac...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/G*

%changelog
