# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(blib.pm)
# END SourceDeps(oneline)
%define module_version 1.30
%define module_name Games-Cryptoquote
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.30
Release: alt1
Summary: Solves Cryptoquotes
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module solves cryptoquote puzzles, where each letter stands for. a different letter.  These puzzles are typically found in newspapers
 with comics and crossword puzzles.  You can also find several
 examples on the internet, which are nice, because you can cut and paste
 into your script for expeditious solving.

 Note that you'll get some pretty interesting results if
 your cryptoquote puzzle does not yield a unique result,
 or if it uses words that are not in your dictionary.


Public Methods:

new (constructor)

 takes no arguments.

quote

 get/set quote.

source

 get/set source (where the quote came from -- author, etc.).

timeout

 get/set timeout (number of seconds before giving up).

build_dictionary

 Build a huge hash, using either a dictionary like /usr/share/dict/words
 or a specially-formatted patterns file, which takes a lot less time to
 process.

write_patterns

 Read in a dictionary file, like /usr/share/dict/words, and write out
 a specially-formatted patterns file, which takes a lot less time to
 process.

solve

 Do the dirty work.  Assign solution variables for later access via
 the solution() method.

solution

 Obtain the solution for either the quote or the source.  Specify which
 one you want with an argument of "quote" or "source".

See the README for the introduction.

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc CHANGES README COPYING
%perl_vendor_privlib/G*

%changelog
