# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name Games-Dice-Roller
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: a full featured dice roller system
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LO/LORENZO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Games::Dice::Roller;

_my $dice = Games::Dice::Roller->new();

_# simple dice expressions
_my @simple = (qw( 3d6 4d8+4 1d100-5 ));

_# average results
_my @average = (qw(4d4avg 4d8avg+2 4d12avg-7));

_# reroll if equal (default), lesser than or greater than N
_my @reroll = (qw(6d4r1 5d6rlt3 5d6rgt4 6d4r1+10 6d4r1-5));

_# explode if equal (default), lesser than or greater than N 
_my @explode = (qw( 3d6x6 3d6xlt3 3d6xgt4 3d6x6+3 3d6x6-4 ));

_# just count succesful rolls
_my @succes = (qw( 3d6cs1 3d6cslt3 3d6csgt4 ));

_# keep and drop dice from final results
_my @keep_and_drop = (qw( 4d6kh3 4d6kh2 4d6kl2+3 4d6kl2-3 4d12dh1 4d12dl3 4d12dl3+3 4d12dl1-4 ));
_

_foreach my $dice_expression ( @simple , @average, @reroll, @explode, @succes, @keep_and_drop ){

__my ($res, $descr) = $dice->roll( $dice_expression );
__print "$res [$dice_expression] $descr\n";
_}



_# 10 [3d6] 5 2 3
_# 22 [4d8+4] 7 7 1 3 +4
_# 14 [1d100-5] 19 -5
_# 10 [4d4avg] 2.5 2.5 2.5 2.5
_# 20 [4d8avg+2] 4.5 4.5 4.5 4.5 +2
_# 19 [4d12avg-7] 6.5 6.5 6.5 6.5 -7
_# 18 [6d4r1] 4 (1r) 3 2 3 (1r) 2 4
_# 19 [5d6rlt3] 3 4 3 4 (2r) (2r) (2r) 5
_# 11 [5d6rgt4] 2 4 1 (5r) 2 (5r) 2
_# 25 [6d4r1+10] (1r) 2 (1r) 2 2 4 3 2 +10
_# 13 [6d4r1-5] (1r) (1r) 2 (1r) 2 4 4 (1r) 4 2 -5
_# 7 [3d6x6] 1 1 5
_# 17 [3d6xlt3] 6 5 1x 1x 1x 3
_# 11 [3d6xgt4] 4 3 4
_# 11 [3d6x6+3] 2 2 4 +3
_# 8 [3d6x6-4] 5 3 4 -4
_# 1 [3d6cs1] (5) (3) 1
_# 1 [3d6cslt3] 2 (6) (6)
_# 2 [3d6csgt4] 6 (3) 5
_# 14 [4d6kh3] (2) 6 4 4
_# 9 [4d6kh2] 3 6 (2) (2)
_# 8 [4d6kl2+3] (6) 4 1 (6) +3
_# 1 [4d6kl2-3] (5) 1 3 (3) -3
_# 13 [4d12dh1] 2 6 5 (6)
_# 12 [4d12dl3] (9) (10) (9) 12
_# 9 [4d12dl3+3] (1) 6 (3) (6) +3
_# 26 [4d12dl1-4] 9 (1) 9 12 -4

_


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%changelog
