%define module_name Games-EveOnline-API
# BEGIN SourceDeps(oneline):
BuildRequires: perl(LWP/UserAgent.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Test/Simple.pm) perl(Type/Tiny.pm) perl(URI.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: A simple Perl wrapper around the EveOnline XML API.
Group: Development/Perl
License: perl
URL: https://github.com/bluefeet/Games-EveOnline-API

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BL/BLUEFEET/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a Perl wrapper around the Eve-Online API, version 2.
The need for the wrapper arrises for two reasons.  First, the XML that
is provided by the API is overly complex, at least for my taste.  So, other
than just returning you a perl data representation of the XML, it also
simplifies the results.

Second, I want to write a the DBIx::Class manpage wrapper around the API, and it
made more sense to first create a low-level perl interface to the API,
and then use it to power the higher level DBIC API.

Only a couple of the methods provided by this module can be used straight
away.  The rest require that you get a user_id and api_key.  You can get
these at:

http://myeve.eve-online.com/api/default.asp

Also, this modules does not attempt to duplicate the documentation already
provided by CCP.  Read their API docs too:

http://myeve.eve-online.com/api/doc/


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/G*

%changelog
