# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Image/LibRSVG.pm) perl(Test.pm) perl(XML/LibXML.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Games-Go-SGF2misc-SVG
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Package to simplify SGF game rendering using Image::LibrSVG
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/OR/ORIEN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Games::Go::SGF2misc::SVG is a Perl Wrapper for the Image::LibRSVG.pm module.
It simplifies the process of rendering an image from an SGF file.  It is
however still a primitive interface, in that it does not contain any
internal intellegence about how to process an SGF file, this is merely
designed to be used in conjunction with an SGF reader such as
the Games::Go::SGF2misc manpage or the Games::Go::SGF manpage.

$image = Games::Go::SGF2misc::SVG-new(['imagesize' => 1in],['boardsize' => 19],['gobanColor' => 'white'])>

    To create a new image, call the new() function.  It's three
    arguments are optional, but if specified will override the defaults.

    imagesize is the width and height of the image created and
    defaults to 2in if not specified.  boardsize is the number of
    lines horizontally and vertically across the board, with a default
    of 19.  
    
    gobanColor, b<whiteColor> and b<blackColor> are either an array of 
    integers between 0 and 255, and SVG color keyword name, or an SVG
    hextriplet in the form #FFFFFF, much like html.

$image-drawGoban()>

    This command does all the initial setup of rendering the Goban.  It
    sets the background color, and draws lines and star points.  If you
    don't call this before any of the other drawing functions, you can
    expect your output to be a little weird.

$image-placeStone($color,$position)>

    This command puts a stone into the image at the position specified.
    $color is one of /[BbWw]/ and controls whether a black or white
    stone is added. $position is either an array of x,y coordinates
    with 0,0 in the upper left corner, or a string of letters
    representing coordinates at which the stone should be placed, in
    standard SGF format. 'aa' is the upper left corner, and 'ss' is the
    lower right (of a 19x19 game).

$image-addCircle($position)>
$image-addSquare($position)>
$image-addTriangle($position)>

    This command adds either a circle, square or triange around the
    coordinates specified by $position.

$image-addLetter($position,$letter)>

    This command renders a letter above the coordinates specified by
    $position.  The processing performed is very similar to the other
    add* functions defined above.

$image-save($filename)>

    Saves the in memory image into the filename specified in
    $filename.  The image will be saved as an uncompressed SVG file.

$image-export($filename)>

    Exports the in memory image into the filename specified in
    $filename as an image in PNG format.

$png = $image-dump($format)>

    Converts the in memory image into an image of the format specified
    in $format.  If no format is specified the module defaults to
    SVG.  The image is then returned to the calling function for
    storage.  The possible formats are 'SVG', and 'PNG'.

    ** dump as PNG Not currently supported **
    This function will be supported once it is supported by Image::LibRSVG
    which is, in turn, waiting for necessary support from gdk-pixbuf.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%changelog
