# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Games-WordFind
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Class for generating Word Find type puzzles
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AJ/AJOHNSON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module simply provides a class which can be
used to generate WordFind type puzzles. It is simple
to use, the relevant methods are:

=over 4

=item $puzzle = Games::WordFind->new({cols => 10,intersect=>1});

Obviously, this returns a WordFind object. By default the puzzle
created by this object is a 10x10 lattice---you may give an
optional hash reference with a 'cols' as the key and some number
as the value for the size of the lattice. You may also provide an
'intersect' key, which allows words to intersect in the puzzle
(share letters) when set to a non-zero value.

=item $puzzle->create_puzzle(LIST)

This method takes the LIST of words and creates the puzzle. Any
words which are longer than the number of columns in the puzzle
are dropped from the wordlist and a warning is issued. This
method will return references to three arrays; a two dimensional
array of the puzzle, an array of the words used, and a two
dimensional array of the puzzle solution. These are so you can
format your puzzle output yourself rather than using the latex or
html formatting functions described next.

=item $puzzle->get_plain({solution => 1})

This method gets the puzzle and its solution matrix
in a plain text format. If you supply the optional
hash reference with a non-zero value for 'solution',
a solution matrix is included immediately following
the puzzle. 

=item $puzzle->get_latex({solution => 1, wrapper => 1})

This method a latex formatted version of the puzzle containing
tabular environments to set the puzzle and solution (a newpage
separates the two). The optional hash argument can contain the
key 'wrapper' which tells the method to return the puzzle wrapped
with a latex preamble, and the key 'solution' which will return
the solution matrix after a `\newpage' command in the latex source.

=item $puzzle->get_html({solution =>1, wrapper =>1})

Similar to the latex method, though, of course, there is no
newpage separation of the solution.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/G*
%perl_vendor_privlib/auto/*

%changelog
