# BEGIN SourceDeps(oneline):
BuildRequires: perl(CHI.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(JSON/MaybeXS.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(LWP/UserAgent/Throttled.pm) perl(Params/Get.pm) perl(Test/Carp.pm) perl(Test/DescribeMe.pm) perl(Test/LWP/UserAgent.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/NoWarnings.pm) perl(Test/Number/Delta.pm) perl(Test/RequiresInternet.pm) perl(Time/HiRes.pm) perl(URI.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Geo-Coder-GeoApify
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Provides a Geo-Coding functionality using L<https://www.geoapify.com/maps-api/>
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Geo::Coder::GeoApify provides an interface to https://www.geoapify.com/maps-api/,
a free Geo-Coding database covering many countries.

=over 4

=item * Caching

Identical geocode requests are cached (using the CHI manpage or a user-supplied caching object),
reducing the number of HTTP requests to the API and speeding up repeated queries.

This module leverages the CHI manpage for caching geocoding responses.
When a geocode request is made,
a cache key is constructed from the request.
If a cached response exists,
it is returned immediately,
avoiding unnecessary API calls.

=item * Rate-Limiting

A minimum interval between successive API calls can be enforced to ensure that the API is not overwhelmed and to comply with any request throttling requirements.

Rate-limiting is implemented using the Time::HiRes manpage.
A minimum interval between API
calls can be specified via the `min_interval' parameter in the constructor.
Before making an API call,
the module checks how much time has elapsed since the
last request and,
if necessary,
sleeps for the remaining time.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/G*

%changelog
