%define module_name Geo-IPinfo
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cache/LRU.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Headers.pm) perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Net/CIDR.pm) perl(Net/CIDR/Set.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.1.1
Release: alt1
Summary: Official Perl module to use ipinfo.io geolocation services
Group: Development/Perl
License: apache
URL: https://ipinfo.io

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IP/IPINFO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Geo::IP provides an object-oriented perl interface to https://ipinfo.io geolocation services

A quick usage example:

    use Geo::IPinfo;

    my $token = "1234567";

    # if you have a valid token, use it
    my $ipinfo = Geo::IPinfo->new($token);

    # or, if you don't have a token, use this:
    # my $ipinfo = Geo::IPinfo->new();

    # return a hash reference containing all IP related information
    my $data = $ipinfo->info("8.8.8.8");

    if (defined $data)   # valid data returned
    {
      print "Information about IP 8.8.8.8:\n";
      for my $key (sort keys %%$data )
      {
        printf "%%10s : %%s\n", $key, $data->{$key};
      }
      print "\n";
    }
    else   # invalid data obtained, show error message
    {
      print $ipinfo->error_msg . "\n";
    }

    # retrieve only city information of the IP address
    my $city = $ipinfo->field("8.8.8.8", "city");

    print "The city of 8.8.8.8 is $city\n";

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt Changes
%perl_vendor_privlib/G*

%changelog
