%define module_name Geo-LibProj-cs2cs
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IPC/Run3.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(lib.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: IPC interface to PROJ cs2cs
Group: Development/Perl
License: artistic_2
URL: https://github.com/johannessen/cs2cs-perl

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AJ/AJNN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is a Perl interprocess communication interface
to the cs2cs(1) utility, which
is a part of the PROJ coordinate transformation
library.

Unlike the Geo::Proj4 manpage, this module is pure Perl. It does require the
PROJ library to be installed, but it does not use the PROJ API
via_XS. Instead, it communicates with the `cs2cs' utility using
the standard input/output streams, just like you might do at a
command line. Data is formatted using `sprintf' and parsed using
regular expressions.

As a result, this module may be expected to work with many different
versions of the PROJ library, whereas the Geo::Proj4 manpage is limited to
version_4 (at time of this writing). However, this module is
definitely less efficient and possibly also less robust with regards
to potential changes to the `cs2cs' input/output format.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/G*

%changelog
