# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor.pm) perl(Class/Factory.pm) perl(Error.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/TableExtract.pm) perl(LWP/UserAgent.pm) perl(Storable.pm) perl(Test/More.pm) perl(URI/Escape.pm) perl(XML/Simple.pm) perl(base.pm) perl(overload.pm) perl(HTML/TreeBuilder.pm) perl(HTML/ElementTable.pm)
# END SourceDeps(oneline)
%define module_version 0.10
%define module_name Geo-OSM-MapFeatures
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: Parses and represents OpenStreetMap Map Features
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BO/BOBKARE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Geo::OSM::MapFeatures;. 
 my $mf = new Geo::OSM::MapFeatures;
 $mf->download();
 $mf->parse();
 
 # To print a simple ascii representation:
 foreach my $category ( sort( $mf->categories() ) ){
     print "\n\n===== $category =====\n";
     foreach my $feature ( $mf->features($category) ){
         print "$feature\n";
     }
 }
 
 # Or you can choose not to use the string overloading and get the
 # individual elements yourself:
 foreach my $category ( sort( $mf->categories() ) ){
     print "\n\n===== $category =====\n";
     foreach my $feature ( $mf->features($category) ){
         print "Key: ".$feature->key()."\n";
         print "Value(s): ". join("\n          ", @{$feature->values()})."\n";
         print "Description: ".$feature->description()."\n\n";
     }
 }


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/G*

%changelog
