%define module_name Geo-Spline
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Geo/Constants.pm) perl(Geo/Ellipsoids.pm) perl(Geo/Functions.pm) perl(Test/Simple.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Calculate geographic locations between GPS fixes.
Group: Development/Perl
License: perl
URL: https://github.com/mrdvt92/perl-Geo-Spline

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MR/MRDVT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This program was developed to be able to calculate the position between two GPS fixes using a 2-dimensional 3rd order polynomial spline..
  f(t)  = A + B(t-t0)  + C(t-t0)^2 + D(t-t0)^3 #position in X and Y
  f'(t) = B + 2C(t-t0) + 3D(t-t0)^2            #velocity in X and Y

I did some simple Math (for an engineer with a math minor) to come up with these formulas to calculate the unknowns from our knowns.

  A = x0                                     # when (t-t0)=0 in f(t)
  B = v0                                     # when (t-t0)=0 in f'(t)
  C = (x1-A-B(t1-t0)-D(t1-t0)^3)/(t1-t0)^2   # solve for C from f(t)
  C = (v1-B-3D(t1-t0)^2)/2(t1-t0)            # solve for C from f'(t)
  D = (v1(t1-t0)+B(t1-t0)-2x1+2A)/(t1-t0)^3  # equate C=C then solve for D

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md doc
%perl_vendor_privlib/G*

%changelog
