# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(Exporter.pm) perl(Text/Wrap.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name	 Geo-WeatherNOAA
%define upstream_version 4.38

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:	Perl extension for interpreting the NOAA weather data
License:	GPL
Group:		Development/Perl
Url:		https://metacpan.org/release/%{upstream_name}
Source0:	https://cpan.metacpan.org/modules/by-module/Geo/%{upstream_name}-%{upstream_version}.tar.bz2

BuildRequires:	perl-devel
BuildRequires:  perl(Tie/IxHash.pm)
BuildRequires:  perl(LWP/Simple.pm)
BuildArch:	noarch
Source44: import.info


%description
This module is intended to interpret the NOAA zone forecasts and current 
city hourly data files. It should give a programmer an easy time to use 
the data instead of having to mine it.

Be aware that if the variable $main::opt_v is set to anything (other than 
zero or '') then Geo::WeatherNOAA will be verbose on what it's doing with 
messages sent to STDERR. Useful for debugging. 

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor 
make OPTIMIZE="$RPM_OPT_FLAGS" 

%install
%makeinstall_std 

%check
make test

%files
%doc README
%{perl_vendor_privlib}/Geo/*

%changelog
