# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long.pm) perl(Test/More.pm) perl(constant.pm) perl(diagnostics.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name Getopt-ApacheCommonsCLI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Perl extension for parsing arguments similar to Apache Commons CLI Java library.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JB/JBRIGGS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Getopt::ApacheCommonsCLI - Perl extension for parsing arguments similar to Apache Commons CLI Java library.

The Apache Commons CLI Java library implements options parsing according to at least 3 different standards:

=over

=item 1.
Unix

=item 2.
POSIX (bundling, enabled with OPTIONS_BUNDLING=1 flag)

=item 3.
Java (-D options with right-to-left argument precedence, enabled with JAVA_DOPTS=1)

=back

Certainly there will be parsing ambiguities. An example is that single-character option bundling
and non-spaced single-character option args can be parsed in multiple ways for the same input.

If you need 100%% compatibility, then it would be advisable to use the original Apache Commons CLI
Java library. However, if "pretty close" is adequate, then use this module, or consider submitting a bug report or patch.

Also, as the Getopt::Long module says, "Note: Using option bundling can easily lead to unexpected results,
especially when mixing long options and bundles. Caveat emptor."

Here are some definitions for the purpose of this module:

=over

=item *
'single-character option' (ie. -a)

=item *
'long option' is the longest option name or alias for an option (ie. --password)

=item *
'short option' is the shortest option name or alias for an option (usually a single-character option) (ie. -pw)

=item *
'Java option' is a single-character option starting with '-D' or '--D' and contains '=' (ie. -Dabc=xyz)

=item *
'bundling' is combining multiple single-character options after a single dash or double dash. (ie. ls -lat)

=back

This Perl module implements:

=over

=item *
options can have both a long and short name

=item *
space or = for trailing option arguments

=item *
allows single-character options to have a non-spaced trailing arg

=item *
options that are seen but don't take an arg have their value set to 1.

=item *
does not enable POSIX single-character options bundling by default, defined in OPTIONS_BUNDLING

=item *
argument assignment precedence is defined in LEFT_TO_RIGHT_ARGS flag, default is from left to right (Java standard is right-to-left)

=item *
Java options parsing is defined with JAVA_DOPTS, default is disabled

=item *
customized error message subroutine for missing args.

=back

For multiple-value arguments, either quote or comma-separate them. Read Getopt::Long documentation for more information.

Input specification format is: "(long-option)|(short-option)[:=]?([fios])?".

 my $result = GetOptionsApacheCommonsCLI(\@spec, \%%opts, \%%options, \&do_err);

 $opts{'__argv__'}   is the string remaining after GetOpt::Long processing.
 $opts{'__errors__'} is the list of parsing errors.

%%options may contain:

 AMBIGUITIES (reserved for future use in disambiguating short option names)
 BUNDLING (default=0, enabled=1 activates Getopt::Long's bundling_override)
 DEBUG (default=0, enabled=1)
 JAVA_DOPTS (default=0, enabled=1, implies post-processing with OPT_PREC_RIGHT_TO_LEFT for matching options)
 OPT_PRECEDENCE (default=OPT_PREC_UNIQUE, also OPT_PREC_LEFT_TO_RIGHT and OPT_PREC_RIGHT_TO_LEFT)

Return values

=over

=item *
Getopt::ApacheCommonsCLI returns 1=for success, 0=failure

=item *
a list of errors in $opts{'__errors__'}

=item *
@ARGV contains remainder of command line.

=back
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%changelog
