%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test.pm) perl(base.pm) perl(blib.pm)
# END SourceDeps(oneline)
%define module_version 1.06
%define module_name Getopt-AutoConf
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.06
Release: alt1
Summary: - use autoconf(1)-style options
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DARREN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Getopt::AutoConf allows for autoconf-style parameters with no extra
parsing on the part of the script writer.

The module exports a single function, called GetOptions, which takes a
hash describing what options should be parsed. Each key in this hash
is a variable name, and each value is a reference to a variable into
which the value should be placed, similar to Getopt::Long.  GetOptions
returns 1 on success or undef on failure. The variables referenced
should already be defined, although in the absence of 'use strict'
this is not required.

Getopt::AutoConf::GetOptions is written in such a way that arguments not
beginning with '--enable-', '--disable-', '--with-', or '--without-'
are passed through unmodified; another option processing module can
then process the remaining arguments.  For example:

  use Getopt::Long ();
  use Getopt::AutoConf ();

  my ($foo, $bar, $baz, $quux);
  Getopt::AutoConf::GetOptions('foo' => \$foo, 'bar' => \$bar);
  Getopt::Long::GetOptions('baz' => \$baz, 'quux' => \$quux);

See t/03golngoa.t for another (working) example. Note that in this
case, modules should be used with () as their argument list, and the
functions' full name should be typed, to avoid the name clash.

The keys to the hash passed into GetOptions can be references of one
of three types: references to scalar variables, references to arrays,
or code references.  How each reference type is dereferenced depends
on whether they were preceded by enable, disable, with, or without
(each is detailed below).

Options can be passed in the any of the following forms:

=over 4


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/G*

%changelog
