# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 0.13.1
%define module_name Getopt-Casual
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13.1
Release: alt1
Summary: A casual replacement for other Getopt modules and `-s'.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PH/PHOTO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Getopt::Casual module simplifies the manipulation of command line
arguments in what should be a familiar way to most UNIX command line 
utility users.  The following basic rules explain the assumptions that
the `&casual()' makes for either `&import()' or `@ARGV' command
line processing:

 1)  Arguments can be single characters or and combination of
     characters, although depending on your shell, some characters will
     be interpreted by the shell.

 2)  Arguments that begin with a '-' followed by another item in
     @ARGV, which can include spaces if the string is enclosed by 
     quotes or double quotes, will have the value of that string.  
     See Rule 3.

 3)  Arguments that begin with a '-' followed by another argument in 
     @ARGV that begins with a '-', including quoted strings that 
     contain spaces, will have a value of 1.

 4)  Arguments that do not begin with a '-' will have a value of one.
     When preceded by an odd number of arguments that begin with a dash,
     this string is a value of the previous command line argument.

 5)  Arguments that begin with a '--' have a value of one.  (See Rule 7)

 6)  The string '--' will terminate command line processing.

 7)  If the string contains an '=', the part of the string preceding 
     the first '=' will be a key of %%ARGV and the value will be the
     part following the first '=' until the end of that element of @ARGV.

 8)  All arguments of the script can be found as either a key or a
     value of %%ARGV.

 9)  @ARGV will contain only the arguments that meet the following criteria.

     a)  All arguments after a '--' will be contained in @ARGV unless
	 one of the next two criteria are met first.

     b)  All arguments after the last occurance of an argument that
         begins with a '-' and that arguments value.

				 -OR-

	 All arguments after the last occurance of an argument that
	 contains an '='.

The same set of rules apply to the arguments you pass the import() 
subroutine.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes example
%perl_vendor_privlib/G*

%changelog
