%define module_name Getopt-EX-Config
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Getopt/EX.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) rpm-build-python3
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.9905
Release: alt1
Summary: Getopt::EX module configuration interface
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/Getopt-EX-Config

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides an interface to define configuration information
for `Getopt::EX' modules.  In the traditional way, in order to set
options for a module, it was necessary to define dedicated command
line options for them.  To do so, it is necessary to avoid name
conflicts with existing command options or with other modules used
together.

Using this module, it is possible to define configuration information
only for the module and to define module-specific command options.

You can create config object like this:

    use Getopt::EX::Config;
    my $config = Getopt::EX::Config->new(
        char  => 0,
        width => 0,
        code  => 1,
        name  => "Franky",
    );

This call returns hash object and each member can be accessed like
`$config->{width}'.

You can set these configuration values by calling `config()' function
with module declaration.

    example -Mfoo::config(width,code=0) ...

Parameter list is given by key-value pairs, and `1' is assumed when
value is not given.  Above code set `width' to `1' and `code' to
`0'.

Also module specific options can be taken care of by calling
`deal_with' method from module startup funciton `intialize' or
`finalize'.

    sub finalize {
        our($mod, $argv) = @_;
        $config->deal_with($argv);
    }

Then you can use `--config' module option like this:

    example -Mfoo --config width,code=0 -- ...

The module startup function is executed between the `initialize()'
and `finalize()' calls.  Therefore, if you want to give priority to
module-specific options over the startup function, you must call
`deal_with' in the `finalize()' function.

If you want to make module private option, say `--width' to set `$config->{width}' value, `deal_with' method takes `Getopt::Long'
style option specifications.

    sub finalize {
        our($mod, $argv) = @_;
        $config->deal_with(
            $argv,
            "width!",
            "code!",
            "name=s",
        );
    }

Then you can use module private option like this:

    example -Mcha...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/G*
%perl_vendor_privlib/auto/*

%changelog
