%define module_name Getopt-EX-termcolor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Getopt/EX.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Term/ReadKey.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.08
Release: alt1
Summary: Getopt::EX termcolor module
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/Getopt-EX-termcolor

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a common module for command using the Getopt::EX manpage to manipulate
system dependent terminal color.

Actual action is done by sub-module under the Getopt::EX::termcolor manpage,
such as the Getopt::EX::termcolor::Apple_Terminal manpage.

Each sub-module is expected to have `&get_color' function which
return the list of RGB values for requested name, but currently name
`background' is only supported.  Each RGB values are expected in a
range of 0 to 255 by default.  If the list first entry is a HASH
reference, it may include maximum number indication like `{ max =>
65535 }'.

Terminal luminance is calculated from RGB values by this equation and
produces decimal value from 0 to 100.

    ( 30 * R + 59 * G + 11 * B ) / MAX

=begin comment

If the environment variable `TERM_LUMINANCE' is defined, its value is
used as a luminance without calling sub-modules.  The value of
`TERM_LUMINANCE' is expected in range of 0 to 100.

=end comment

If the environment variable `TERM_BGCOLOR' is defined, it is used as
a background RGB value without calling sub-modules.  RGB value is a
combination of integer described in 24bit/12bit hex, 24bit decimal or
6x6x6 216 color format.  RGB color notation is compatible with
the Getopt::EX::Colormap manpage.

    24bit hex     #000000 .. #FFFFFF
    12bit hex     #000    .. #FFF
    24bit decimal 0,0,0   .. 255,255,255
    6x6x6 216     000     .. 555

You can set `TERM_BGCOLOR' in you start up file of shell.  This
module has utility function `bgcolor' which can be used like this:

    export TERM_BGCOLOR=`perl -MGetopt::EX::termcolor=bgcolor -e bgcolor`
    : ${TERM_BGCOLOR:=#FFFFFF}

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/G*

%changelog
