%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Getopt/Long.pm) perl(IPC/Run.pm) perl(Module/Build.pm) perl(Storable.pm) perl(Test/More.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Getopt-Helpful
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Integrated option hash / help messages.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EW/EWILHELM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module provides methods which integrate help messages into a
Getopt::Long option spec.  This gathers documentation and declaration
into one place and allows you to utilize perl code to state the default
values of options in your online help messages (helping you utilize the
single-point-of-truth principle.)

Additionally, it provides DWIM methods (Get) which allow you to cut some
standard error-checking code from your scripts.  There is even a handy
usage() method which eliminates that silly block of code from the
beginning.

  #!/usr/bin/perl

  use warnings;
  use strict;

  use Getopt::Helpful;
  my $var1 = "default";
  my $req_arg;

  # declare this as 'our' or $main::verbose
  our $verbose = 0;

  # every option must be passed into the constructor...
  my $hopt = Getopt::Helpful->new(
    usage => 'CALLER <argument> [options]',
    [
      'var=s', \$default,
      '<setting>',
      "setting for \$var1 (default: '$var1')"
    ],
    [
      'a|arg', \$req_arg,
      '<argument>',
      'required argument'
    ],
    '+verbose',
    '+help',
    );

  # call GetOptions() behind the scenes (with error-checking)
  $hopt->Get();
  $req_arg or ($req_arg = shift);

  # usage() called with a message results in non-zero exit code
  $req_arg or $hopt->usage('missing required argument');
  $verbose and warn "doing stuff now\n";

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
  # now do stuff...


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/G*

%files scripts
%_bindir/*

%changelog
