# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(diagnostics.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Gettext
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Perl extension for emulating gettext-related API.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JB/JBRIGGS/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Gettext.pm emulates the gettext library routines in Perl, although it calls the external utility program gettext to actually read .mo files.

man gettext on Solaris has pretty good documentation.

The steps to use this module are:

=over 4

=item *

install the gnu gettext package if necessary (not needed on Solaris or Red Hat)

=item *

set TEXTDOMAINDIR, LANGUAGE, LANG, and LC_* if needed in your env.

=item *

use xgettext on your script that contains gettext calles  to make the .po
(portable message object) file, run msgfmt to make the
.mo (message object) file, and move the .mo
file to where you want it, normally $TEXTDOMAINDIR/lang/LC_MESSAGES.

=item *

call setlocale before calling these functions.

=back

use Gettext;

my $gt = new Gettext;

$gt->textdomain('domainname');

$gt->bindtextdomain('domainname', 'dirname');

$gt->gettext('msgid');

$gt->dgettext('domainname', 'msgid');

$gt->dcgettext('domainname', 'msgid', 'category (locale)');


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/demo.pl

%files
%doc Changes
%perl_vendor_privlib/G*
%perl_vendor_privlib/auto/*

%changelog
