# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Gibbs
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1
Release: alt1
Summary: **Author**: MH Seabolt (Github: @hseabolt)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MH/MHSEABOLT/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This package creates a Perl object class representing a Gibbs sampler tailored for MCMC sampling of "mutually similar" motifs from string data.
While written with biological sequences in mind, this package is also suitable for motif-finding from generic strings using any alphabet.

The `Gibbs` package is written in base Perl (v5.32.1).


The code can be obtained/installed in two ways:

1. Install from Github:
```bash
git clone https://github.com/hseabolt/Gibbs.git
cd Gibbs
```

2. Install from `CPAN`
```bash
cpanm gibbs

perl -MCPAN -e shell
install gibbs
```

3. Install using `Conda` (Bioconda)
```bash
conda install -c bioconda gibbs
```

If installing from Github, you can globally install the `Gibbs.pm` package by copying this file to a location that is visible to your `PATH` or Perl's `@INC` variables.


An example script comes packaged with the Github version of this code which illustrates the basic idea of how to create and use the Gibbs object class for motif sampling.
and can be plugged into any scripts running Perl.


This software is licensed under the MIT License.  See also `LICENSE.txt` in this package's Git repo (https://github.com/hseabolt/Gibbs)

> The MIT License
>
> Copyright (c) 2022 Matthew H. Seabolt
>
> Permission is hereby granted, free of charge, 
> to any person obtaining a copy of this software and 
> associated documentation files (the "Software"), to 
> deal in the Software without restriction, including 
> without limitation the rights to use, copy, modify, 
> merge, publish, distribute, sublicense, and/or sell 
> copies of the Software, and to permit persons to whom 
> the Software is furnished to do so, 
> subject to the following conditions:
>
> The above copyright notice and this permission notice 
> shall be included in all copies or substantial portions of the Software.
>
> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
> EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
> OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
> IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR 
> ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
> TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
> SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


If you use this package in your work, please cite:
Seabolt, MH. (2022). Gibbs: a Perl Package for Motif Discovery from Biological Sequences. In prep.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/G*

%changelog
