# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/IniFiles.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Find/Closures.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Getopt/Long.pm) perl(Log/Log4perl.pm) perl(Net/GitHub/V3.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(YAML.pm) perl(subs.pm)
# END SourceDeps(oneline)
%define module_version 0.18
%define module_name Git-Github-Creator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Create a Github repository for your Perl module
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BD/BDFOY/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a short script you can run from within an existing git
repository to create a remote repo on GitHub using a previously
created account. This does not create GitHub accounts
(that would violate the
GitHub terms of service).

If the `--name' and `--desc' switches are not given, it will try
to find them in META.yml. If the script doesn't find a META.yml, it
tries to run `make metafile` (or `Build distmeta`) to create one.

From META.yml it gets the module name and abstract, which it uses for
the GitHub project name and description. It uses the CPAN Search page
as the homepage (e.g. http://search.cpan.org/dist/Foo-Bar).

Once it creates the remote repo, it adds a git remote named "origin"
(unless you change that in the config), then pushes master to it.

If GitHub sends back the right page, the script ends by printing the
private git URL.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/G*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
