%define module_name Git-PunchCard
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error/Helper.pm) perl(Term/ANSIColor.pm) perl(Text/Table.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: Gathers info for making punchcard style graphs for git.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Quick summary of what the module does.

Perhaps a little code snippet.

    use Git::PunchCard;
    use Data::Dumper;
    use Text::Table;
    
    my $gpc = Git::PunchCard->new();
    
    $gpc->dir($some_git_repo_dir);
    if ( $gpc->error ){
        print "Could not process the directory.\n";
    }
    
    my $card=$gpc->get_card;
    
    print Dumper( $card );
    
    # The various keys for the hashes.
    my @days=('Sun','Mon','Tue','Wed','Thu','Fri','Sat', );
    my @hours=('00','01','02','03','04','05','06','07','08','09','10', '11','12','13','14','15','16','17','18','19','20','21','22','23');
    
    # Stores the lines to for the table.
    my @data;

    # Process each day hash in $card.
    foreach my $day ( @days ){
        my @line;
    
        # Add the day coloumn to the current line of the table.
        push( @line, $day );
    
        # Add each hour entry to the current line of the table.
        foreach my $hour ( @hours ){
            push( @line, $card->{$day}{$hour} );
        }
    
        # Finally add the total number of entries for that day.
        push( @line, $card->{$day}{total}.color('WHITE') );
    
        # add the new line to the table data
        push( @data, \@line );
    }
    
    # Init the Text::Table object and add our headers.
    my $table=Text::Table->new('','00','01','02','03','04','05','06','07','08','09','10','11','12','13','14','15','16','17','18','19','20','21','22','23','Total');

    # Loads the data into the table
    $table->load( @data );
    
    # produce some useful? output
    print $table."\nTotal: ".$card->{total}."\n";

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes ignore.txt
%perl_vendor_privlib/G*

%files scripts
%_bindir/*

%changelog
