%define module_name GitHub-Config-SSH-UserData
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec/Functions.pm) perl(Test/More.pm) perl(autodie.pm) perl(constant.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Read user data from comments in ssh config file
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KL/KLAUSRIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module exports a single function (`get_user_data_from_ssh_cfg()') that
is useful when using multiple GitHub accounts with SSH keys.  First, you
should read this gist https://gist.github.com/oanhnn/80a89405ab9023894df7
and follow the instructions.

To use `get_user_data_from_ssh_cfg()', you must add information to your ssh config file (default
~/.ssh/config) by adding comments like this:

  Host github-ALL-ITEMS
  #  User: John Doe <main@addr.xy> <foo@bar> additional data
     HostName github.com
     IdentityFile ~/.ssh/abc
     IdentitiesOnly yes

  Host github-minimal
  #  User: <main@addr.xy>
     HostName github.com
     IdentityFile ~/.ssh/mini
     IdentitiesOnly yes

  Host github-std
  #  User: Jonny Controlletti <main-jc@addr.xy>
     HostName github.com
     IdentityFile ~/.ssh/std
     IdentitiesOnly yes

  Host github-std-data
  #  User: Alexander Platz <AlexPl@addr.xy> more data
     HostName github.com
     IdentityFile ~/.ssh/aaaaa
     IdentitiesOnly yes

The function looks for `Host' names beginning with `github-'. It assumes that
the part after the hyphen is your username on github. E.g., in the example
above the github usernames are `ALL-ITEMS', `minimal', `std' and `std-data'.

The next line must be a comment line beginning with `User:' followed by an
optional name (full name, may contain spaces) followed by one or two email addresses in angle
brackets, optionally followed by another string. See the examples above.

The following function can be exported on demand:

=over

=item `get_user_data(*USER_NAME*, *SSH_CFG_FILE*)'

=item `get_user_data(*USER_NAME*)'

The function scans file *`SSH_CFG_FILE'* (default is
`$ENV{HOME}/.ssh/config' and looks for `Host github-*USER_NAME*'. Then is
scans the `User:' comment in the next line (see description above). It
returns a reference to a hash containing:

=over

=item `full_name'

The full name before the first email address. If no full name is specified,
then the value is set to *`USER_NAME'*.

This key always exists.

=item `email'

The f...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md Changes SECURITY.md LICENSE README
%perl_vendor_privlib/G*

%changelog
