%define module_version 0.05
%define module_name GitMeta
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Log/Log4perl.pm) perl(Pithub.pm) perl(Sysadm/Install.pm) perl(Test/More.pm) perl(YAML.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Clone/update many Git repositories using Meta repos
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MS/MSCHILLI/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
GetMeta allows you to work on dozens of git repositories hosted on different
servers, and update all of your local copies with a single command. It defines
a new syntax, called GMF (git meta format), to configure many different
remote git repository locations and provides a script, `gitmeta-update', 
to create local copies of all of these repos or updates them if they 
already exist. This is useful to 

=over 4

=item *

periodically update your local clones while you have an Internet connection
going so they're up-to-date later when you're offline.

=item *

move to a new system and create clones of all of your favorite git
repos with a single command.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
