# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Exporter.pm) perl(Fcntl.pm) perl(Symbol.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    GnuPG
%define upstream_version 0.19

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_8

Summary:    Perl interface to the GNU privacy guard
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: gnupg
BuildArch:  noarch
Source44: import.info

%description
GnuPG is a perl interface to the GNU Privacy Guard. It uses the shared
memory coprocess interface that gpg provides for its wrappers. It tries its
best to map the interactive interface of the gpg to a more programmatic
model.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make

%check
%make test

%install
%makeinstall_std

%files
%doc COPYING ChangeLog META.json META.yml  NEWS README
%perl_vendor_privlib/*
/usr/bin/gpgmailtunl
/usr/share/man/man1/gpgmailtunl.1*


%changelog
