%define module_name Google-ContentAPI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/JWT.pm) perl(HTML/Entities.pm) perl(JSON.pm) perl(REST/Client.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt1
Summary: Interact with Google's Content API for Shopping
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BG/BGERRARD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Add, modify and delete items from the Google Merchant Center platform via
  the Content API for Shopping.

  Authentication is done via Service Account credentials. See the following for details:
  https://developers.google.com/shopping-content/v2/how-tos/service-accounts

  You will also need to create a Merchant Center Account:
  https://developers.google.com/shopping-content/v2/quickstart

  For convenince, add your Merchant account ID to the *.json file provided by Google.
  Your complete *.json file, after adding your merchant ID, will look something like this:

  {
    "merchant_id": "123456789",
    "type": "service_account",
    "project_id": "content-api-194321",
    "private_key_id": "11b8e20c2540c788e98b49e623ae8167dc3e4a6f",
    "private_key": "-----BEGIN PRIVATE KEY-----
    ...
    -----END PRIVATE KEY-----\n",
    "client_email": "google@content-api.iam.gserviceaccount.com",
    "client_id": "999999999",
    "auth_uri": "https://accounts.google.com/o/oauth2/auth",
    "token_uri": "https://accounts.google.com/o/oauth2/token",
    "auth_provider_x509_cert_url": "https://www.googleapis.com/oauth2/v1/certs",
    "client_x509_cert_url": "https://www.googleapis.com/robot/v1/metadata/x509/google%%40content-api.iam.gserviceaccount.com"
  }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.pod
%perl_vendor_privlib/G*

%changelog
