%define module_name Graphics-Framebuffer
%add_findreq_skiplist */Graphics/Framebuffer.pm
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Map.pm) perl(Imager.pm) perl(Inline.pm) perl(Inline/C.pm) perl(Inline/MakeMaker.pm) perl(List/Util.pm) perl(Math/Bezier.pm) perl(Math/Gradient.pm) perl(Math/Trig.pm) perl(Pod/Usage.pm) perl(Sys/CPU.pm) perl(Term/ANSIColor.pm) perl(Test/More.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 6.52
Release: alt2
Summary: A Simple Framebuffer Graphics Library
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RK/RKELSCH/%{module_name}-%{version}.tar.gz

%description
A (mostly) Pure Perl graphics library for exclusive use in a console framebuffer
environment.  It is written for simplicity without the need for complex API's
and drivers.

Back in the old days, computers drew graphics this way, and it was simple and
easy to do.  I was writing a console based media playing program, and was not
satisfied with the limited abilities offered by the Curses library, and I did
not want the overhead of the X environment to get in the way.  My intention
was to create a mobile media server.  In case you are wondering, that project
has been quite successful, and I am still making improvements to it.

There are places where Pure Perl just won't cut it.  So I use the Imager
library to take up the slack.  It's just used to load and save images, and
draw TrueType text.

I cannot guarantee this will work on your video card, but I have successfully
tested it on NVidia GeForce, AMD Radeon, Matrox,  and VirtualBox displays.
However, you MUST remember, your video driver MUST be framebuffer based.  The
proprietary Nvidia and AMD drivers will NOT work with this module.  You must use
the open source video drivers, such as Nouveau, to be able to use this library.
Also, it is not going to work from within X, so don't even try it.  This is a
console only graphics library.

I highly suggest you use 32 bit mode and avoid 16 bit, as it has been a long time
since I tested it on a 16 bit graphics mode.

NOTE:

If a framebuffer is not available, the module will go into emulation
mode and open a pseudo-screen in the object's hash variable 'SCREEN'

You can write this to a file, whatever.  It defaults to a 640x480x32
graphics 'buffer'.  However, you can change that by passing parameters
to the 'new' method.

You will not be able to see the output directly when in emulation
mode.  I mainly created this mode so that you could install this
module and test code you may be writing to be used on other devices
that have accessible framebuffer devices.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md LICENSE ignore.txt Changes examples
%perl_vendor_archlib/G*
%perl_vendor_autolib/G*

%changelog
