%define module_name Graphics-Grid
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cairo.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Data/Dumper.pm) perl(Eval/Closure.pm) perl(Exporter/Tiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(Forest/Tree.pm) perl(Function/Parameters.pm) perl(Graphics/Color/RGB.pm) perl(Import/Into.pm) perl(List/AllUtils.pm) perl(Math/Trig.pm) perl(Module/Load.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Aliases.pm) perl(MooseX/Clone.pm) perl(MooseX/LazyRequire.pm) perl(MooseX/Storage/Deferred.pm) perl(MooseX/StrictConstructor.pm) perl(Path/Tiny.pm) perl(PerlX/Maybe.pm) perl(Ref/Util.pm) perl(Safe/Isa.pm) perl(Scalar/Util.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test2/V0.pm) perl(Type/Library.pm) perl(Type/Params.pm) perl(Type/Utils.pm) perl(Types/Standard.pm) perl(boolean.pm) perl(feature.pm) perl(namespace/autoclean.pm)
BuildRequires: perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt2
Summary: An incomplete port of the R "grid" library to Perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SL/SLOYD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is alpha code. Before version 1.0 of this library, its API would change
without any notice.

This library is an incomplete port of Paul Murrell's R "grid" library. The R
"grid" library is a low level graphics system that provides full access to
the graphics facilities in R. It's used by some other R plotting libraries
including the famous "ggplot2". 

With my (immature maybe) understanding the fundamental designs and features
of the R "grid" library can be summarized as following:

=over 4

=item *

It supports a few graphical primitives (called "grob") like lines,
rectangles, circles, text, etc. And they can be configured via a set
of graphical parameters (called "gpar"), like colors, line weights and
types, fonts, etc. And, it also has a tree structure called "gTree"
which allows arranging the grobs in a hierachical way.

=item *

It designs something called "viewport" which is basically an arbitrary
rectangular region which defines the transform (position, coordinate scale,
rotation) on the graphics device. There is a global viewport stack 
(actually it's a tree). Viewports can be pushed onto, or popped from the
stack, and drawing always takes place on the "top" or "current" viewport.
Thus for drawing each graphical primitive it's possible to have a specific
transform for the graphics device context. Combined with its ability to
define graphical primitives as mention above, the "grid" library enables
the full possibilities of customization which cannot be done with R's
standard "plot" system.

=item *

It has a "unit" system. a "unit" is basically a numerical value plus a
unit. The default unit is "npc" (Normalised Parent Coordinates), which
describes an object's position or dimension either in relative to those
of the parent viewport or be absolute. So when defining a grob, for
example for a rectangle you can specify its (x, y) position or width or
heightha relative to a viewport, although absolute values are also
possible and you can combine relative and absolute values. Beause of
this design, i...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_privlib/G*

%changelog
