%define module_name Grep-Query
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/DPath.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Scalar.pm) perl(Parse/RecDescent.pm) perl(Test/Differences.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.011
Release: alt1
Summary: Query logic for lists of scalars/objects 
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KN/KNTH/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The visible API is made to be simple but also compact - the single method/function
`qgrep', actually. For the slightly more complex scenarios a helper class is
required, but generally a very simple one giving high flexibility in how to structure
the query itself regardless of how the list itself is laid out.

It has a behavior similar to `grep' - give it a list and get back a list (or
in scalar context, the number of matches). The main difference is that the
matching stuff is a query expressed in a fairly simple language. 

It can be used in both non-OO and OO styles. The latter obviously useful when
the query will be used multiple times so as to avoid parsing the query every
time.

The basic intent is to make it easy to do the easy stuff while still making it
easy to move up to something more complex, without having a wide or wordy API.
This is a two-edged sword - I hope this will not be confusing.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE.md Changes
%perl_vendor_privlib/G*

%files scripts
%_bindir/*

%changelog
