BuildRequires: perl-podlators
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd.pm) perl(DBD/Pg.pm) perl(DBI.pm) perl(DBIx/Simple.pm) perl(Date/Parse.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(Getopt/Long.pm) perl(HTTP/Tiny.pm) perl(IO/Prompter.pm) perl(JSON/MaybeXS.pm) perl(POSIX.pm) perl(PerlX/Maybe.pm) perl(Pod/Usage.pm) perl(SQL/Abstract.pm) perl(Term/ANSIColor.pm) perl(Test/Deep.pm) perl(Test/Perl/Critic.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Gruntmaster-Data
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 6000.001
Release: alt1
Summary: Gruntmaster 6000 Online Judge -- database interface and tools
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Gruntmaster::Data is the interface to the Gruntmaster 6000 database.

All functions are exported by default.

=over

=item dbinit(*@args*)

This function connects to the database. *@args* are the arguments
passed to the the DBIx::Simple manpage constructor.

=item purge(*$url_path*)

Purges a relative URL from the Varnish Cache by sending PURGE
$url_path requests to all hosts in the PURGE_HOSTS environment
variable.

=item db

Returns a the DBIx::Simple manpage object for interacting with the database
directly. Use this when no other function in this module is suitable.

=item user_list

Returns an arrayref of the top 200 users.

=item user_entry(*$id*)

Returns a hashref describing the user *$id*.

=item problem_list([*%%args*])

Returns an arrayref of problems.

Takes the following named arguments:

=over

=item owner

Only show problems owned by this user

=item contest

Only show problems in this contest

=item private

If true, include private problems. Always true if contest is present.

=item solution

If true, include problem solutions

=back

=item problem_entry(i<$id>, [*$contest*])

Returns a hashref describing the problem *$id*. If $contest is
present, contest start and stop times are included, and the solution
is deleted.

=item contest_list

Returns an arrayref of contests.

=item contest_entry(*$id*)

Returns a hashref describing the contest *$id*.

=item contest_has_problem(*$contest*, *$problem*)

Returns true if the contest *$contest* includes the problem
*$problem*, false otherwise.

=item job_list([*%%args*])

In scalar context, returns an arrayref of jobs. In list context,
returns an arrayref of jobs and a hashref of information about pages.

Takes the following named arguments:

=over

=item page

Show this page of the job log. Defaults to 1.

=item owner

Only show jobs submitted by this user.

=item contest

Only show jobs submitted in this contest.

=item problem

Only show jobs submitted for this problem.

=item result

Only show jobs with this result (see the constants in
the Grun...

%package scripts
Summary: %name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/G*

%files scripts
%_bindir/*
%_man1dir/*
%_man1dir/*


%changelog
