# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Devel/GlobalDestruction.pm) perl(Devel/Loading.pm) perl(Devel/StackTrace.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Glib.pm) perl(Glib/Ex/ObjectBits.pm) perl(Glib/Ex/SignalIds.pm) perl(Glib/Object/Subclass.pm) perl(Gtk2.pm) perl(Gtk2/Ex/Units.pm) perl(Gtk2/Pango.pm) perl(I18N/Langinfo.pm) perl(List/Util.pm) perl(Locale/Messages.pm) perl(Locale/TextDomain.pm) perl(POSIX.pm) perl(PerlIO.pm) perl(Pod/Simple/HTML.pm) perl(Scalar/Lazy.pm) perl(Scalar/Util.pm) perl(Smart/Comments.pm) perl(Test/More.pm) perl(Test/Weaken/Gtk2.pm) perl(base.pm) perl(lib/abs.pm)
# END SourceDeps(oneline)
%define module_version 11
%define module_name Gtk2-Ex-ErrorTextDialog
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 11
Release: alt1
Summary: Dialog showing error messages in a TextView.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/gtk2-ex-errortextdialog/index.html

Source0: http://cpan.org.ua/authors/id/K/KR/KRYDE/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
An ErrorTextDialog presents text error messages to the user in a
`Gtk2::TextView'.  It's intended for technical things
like Perl errors and warnings, rather than results of normal user
operations.

    +------------------------------------+
    |   !!    An error has occurred      |
    | +--------------------------------+ |
    | | Something at foo.pl line 123   | |
    | | -----                          | |
    | | Cannot whatever at Bar.pm line | |
    | | 456                            | |
    | |                                | |
    | +--------------------------------+ |
    +------------------------------------+
    |              Clear  Save-As  Close |
    +------------------------------------+

See the Gtk2::Ex::ErrorTextDialog::Handler manpage for functions hooking Glib
exceptions and Perl warnings to display in an ErrorTextDialog.

ErrorTextDialog is good if there might be a long cascade of messages from
one problem, or errors repeated on every screen draw.  In that case the
dialog scrolls along but the app might still mostly work.

The Save-As button lets the user write the messages to a file, for example
for a bug report.  Cut-and-paste works in the usual way too.


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYING Changes examples
%perl_vendor_privlib/G*

%changelog
